<?php
include 'config.php';
if(!isset($_SESSION['user_name'])) {
    header("Location: login.php");
    exit();
}

// Handle form submission
if($_POST) {
    $sdate = $_POST['sdate'];
    $item = $_POST['item'];
    $barcode = $_POST['barcode'];
    $remark = $_POST['remark'];
    $cusname = $_POST['cusname'];
    $cusadd = $_POST['cusadd'];
    $custele = $_POST['custele'];
    $cuswapp = $_POST['cuswapp'];
    
    // Get next ref_no
    $sql = "SELECT MAX(ref_no) as max_ref FROM x_barcode";
    $stmt = $pdo->query($sql);
    $row = $stmt->fetch();
    $ref_no = $row['max_ref'] + 1;
    
    $sql = "INSERT INTO x_barcode (ref_no, sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$ref_no, $sdate, $_SESSION['user_name'], $item, $barcode, $remark, $cusname, $cusadd, $custele, $cuswapp]);
}

// Fetch records
$sql = "SELECT ref_no, sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp FROM x_barcode ORDER BY ref_no DESC";
$stmt = $pdo->query($sql);
$records = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard</title>
    <script src="https://unpkg.com/html5-qrcode/minified/html5-qrcode.min.js"></script>
    <style>
        * { font-family: Arial; margin: 0; padding: 0; box-sizing: border-box; font-size: 10px; }
        body { background: #f5f5f5; }
        .header { background: #2c3e50; color: white; padding: 10px; position: fixed; top: 0; width: 100%; z-index: 1000; }
        .container { margin-top: 40px; padding: 10px; }
        .form-section, .scanner-section, .records-section { background: white; margin: 10px 0; padding: 15px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        input, textarea, select { width: 100%; padding: 8px; margin: 3px 0; border: 1px solid #ddd; border-radius: 4px; font-size: 10px; }
        button { padding: 8px 15px; background: #3498db; color: white; border: none; border-radius: 4px; font-size: 10px; cursor: pointer; }
        table { width: 100%; border-collapse: collapse; font-size: 9px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f8f9fa; }
        #reader { width: 100%; height: 200px; border: 2px dashed #ccc; margin: 10px 0; }
        .scan-animation { border-color: #3498db; animation: pulse 1s infinite; }
        @keyframes pulse { 0% { border-color: #3498db; } 50% { border-color: #2ecc71; } 100% { border-color: #3498db; } }
        .nav { display: flex; justify-content: space-around; margin-bottom: 10px; }
        .nav-btn { flex: 1; text-align: center; padding: 8px; background: #34495e; color: white; margin: 0 2px; }
    </style>
</head>
<body>
    <div class="header">
        <div style="float:left">Welcome: <?php echo $_SESSION['user_name']; ?></div>
        <div style="float:right"><a href="logout.php" style="color:white; text-decoration:none;">Logout</a></div>
        <div style="clear:both"></div>
    </div>

    <div class="container">
        <div class="nav">
            <div class="nav-btn" onclick="showSection('form')">Add Record</div>
            <div class="nav-btn" onclick="showSection('scanner')">Scanner</div>
            <div class="nav-btn" onclick="showSection('records')">View Records</div>
        </div>

        <!-- Add Record Form -->
        <div id="form-section" class="form-section">
            <h3>Add New Record</h3>
            <form method="POST">
                <input type="text" name="ref_no" placeholder="Ref No (Auto)" disabled>
                <input type="date" name="sdate" required>
                <input type="text" name="user_name" value="<?php echo $_SESSION['user_name']; ?>" disabled>
                <input type="text" name="item" placeholder="Item" required>
                <input type="text" id="barcode" name="barcode" placeholder="Barcode" required readonly>
                <textarea name="remark" placeholder="Remark"></textarea>
                <input type="text" name="cusname" placeholder="Customer Name">
                <input type="text" name="cusadd" placeholder="Customer Address">
                <input type="text" name="custele" placeholder="Customer Telephone">
                <input type="text" name="cuswapp" placeholder="Customer WhatsApp">
                <button type="submit">Save Record</button>
            </form>
        </div>

        <!-- Scanner Section -->
        <div id="scanner-section" class="scanner-section" style="display:none;">
            <h3>Barcode/QR Scanner</h3>
            <div id="reader" class="scan-animation"></div>
            <button onclick="startScanner()">Start Scanner</button>
            <button onclick="stopScanner()">Stop Scanner</button>
        </div>

        <!-- Records Section -->
        <div id="records-section" class="records-section" style="display:none;">
            <h3>Records</h3>
            <div style="overflow-x:auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Ref No</th><th>Date</th><th>User</th><th>Item</th><th>Barcode</th>
                            <th>Remark</th><th>Customer</th><th>Address</th><th>Telephone</th><th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($records as $record): ?>
                        <tr>
                            <td><?php echo $record['ref_no']; ?></td>
                            <td><?php echo $record['sdate']; ?></td>
                            <td><?php echo $record['user_name']; ?></td>
                            <td><?php echo $record['item']; ?></td>
                            <td><?php echo $record['barcode']; ?></td>
                            <td><?php echo $record['remark']; ?></td>
                            <td><?php echo $record['cusname']; ?></td>
                            <td><?php echo $record['cusadd']; ?></td>
                            <td><?php echo $record['custele']; ?></td>
                            <td><?php echo $record['cuswapp']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        let html5QrcodeScanner;

        function showSection(section) {
            document.getElementById('form-section').style.display = 'none';
            document.getElementById('scanner-section').style.display = 'none';
            document.getElementById('records-section').style.display = 'none';
            
            document.getElementById(section + '-section').style.display = 'block';
        }

        function startScanner() {
            html5QrcodeScanner = new Html5QrcodeScanner(
                "reader", { fps: 10, qrbox: 250 });
            
            html5QrcodeScanner.render((decodedText, decodedResult) => {
                document.getElementById('barcode').value = decodedText;
                stopScanner();
                showSection('form');
                alert('Barcode scanned: ' + decodedText);
            });
        }

        function stopScanner() {
            if(html5QrcodeScanner) {
                html5QrcodeScanner.clear().catch(error => {
                    console.error("Failed to clear html5QrcodeScanner. ", error);
                });
            }
        }

        // Hide browser address bar on mobile
        window.addEventListener('load', function() {
            setTimeout(function() {
                window.scrollTo(0, 1);
            }, 0);
        });

        // Prevent zoom on double tap
        document.addEventListener('touchstart', function(event) {
            if(event.touches.length > 1) {
                event.preventDefault();
            }
        });
    </script>
</body>
</html>