<?php
include 'config.php';

if ($_POST) {
    $user_name = $_POST['user_name'];
    $user_pass1 = $_POST['user_pass1'];
    
    $stmt = $pdo->prepare("SELECT * FROM user_mast WHERE user_name = ? AND user_pass1 = ?");
    $stmt->execute([$user_name, $user_pass1]);
    $user = $stmt->fetch();
    
    if ($user) {
        $_SESSION['user_name'] = $user['user_name'];
        header("Location: dashboard.php");
        exit();
    } else {
        $error = "Invalid username or password!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Barcode App</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0; 
            padding: 20px; 
            background: #f5f5f5;
        }
        .login-container { 
            max-width: 400px; 
            margin: 100px auto; 
            background: white; 
            padding: 20px; 
            border-radius: 10px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        input[type="text"], input[type="password"] { 
            width: 100%; 
            padding: 10px; 
            margin: 10px 0; 
            border: 1px solid #ddd; 
            border-radius: 5px; 
            box-sizing: border-box;
        }
        button { 
            width: 100%; 
            padding: 12px; 
            background: #007bff; 
            color: white; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer;
        }
        .error { color: red; text-align: center; }
    </style>
</head>
<body>
    <div class="login-container">
        <h2 style="text-align: center;">Barcode Scanner Login</h2>
        <?php if (isset($error)) echo "<p class='error'>$error</p>"; ?>
        <form method="POST">
            <input type="text" name="user_name" placeholder="Username" required>
            <input type="password" name="user_pass1" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>