<?php
include 'config.php';

if (!isset($_SESSION['user_name'])) {
    header("Location: index.php");
    exit();
}

// Handle form submission
if ($_POST) {
    $sdate = $_POST['sdate'];
    $item = $_POST['item'];
    $barcode = $_POST['barcode'];
    $remark = $_POST['remark'];
    $cusname = $_POST['cusname'];
    $cusadd = $_POST['cusadd'];
    $custele = $_POST['custele'];
    $cuswapp = $_POST['cuswapp'];
    
    $stmt = $pdo->prepare("INSERT INTO x_barcode (sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$sdate, $_SESSION['user_name'], $item, $barcode, $remark, $cusname, $cusadd, $custele, $cuswapp]);
    
    $success = "Record saved successfully!";
}

// Get existing records
$stmt = $pdo->prepare("SELECT ref_no, sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp FROM x_barcode ORDER BY ref_no DESC LIMIT 10");
$stmt->execute();
$records = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Barcode App</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/quagga/0.12.1/quagga.min.js"></script>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0; 
            padding: 0; 
            background: #f5f5f5;
        }
        .header { 
            background: #007bff; 
            color: white; 
            padding: 15px; 
            text-align: center;
        }
        .container { 
            padding: 15px; 
        }
        .form-group { 
            margin-bottom: 15px; 
        }
        label { 
            display: block; 
            margin-bottom: 5px; 
            font-weight: bold;
        }
        input, textarea { 
            width: 100%; 
            padding: 10px; 
            border: 1px solid #ddd; 
            border-radius: 5px; 
            box-sizing: border-box;
        }
        button { 
            padding: 12px 20px; 
            background: #28a745; 
            color: white; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
            margin: 5px;
        }
        .scanner-container { 
            margin: 20px 0; 
            text-align: center;
        }
        #barcode-scanner { 
            width: 100%; 
            height: 300px; 
            background: #000; 
            margin: 10px 0;
        }
        .record-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 20px;
            background: white;
        }
        .record-table th, .record-table td { 
            border: 1px solid #ddd; 
            padding: 8px; 
            text-align: left;
            font-size: 12px;
        }
        .record-table th { 
            background: #f8f9fa;
        }
        .menu { 
            background: #343a40; 
            padding: 10px; 
            text-align: center;
        }
        .menu button { 
            background: #6c757d; 
            margin: 0 5px;
        }
        .success { color: green; text-align: center; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Barcode Scanner App</h2>
        <p>Welcome, <?php echo $_SESSION['user_name']; ?>!</p>
    </div>
    
    <div class="menu">
        <button onclick="showSection('scanner')">Scan Barcode</button>
        <button onclick="showSection('records')">View Records</button>
        <button onclick="location.href='logout.php'">Logout</button>
    </div>

    <div class="container">
        <?php if (isset($success)) echo "<p class='success'>$success</p>"; ?>

        <!-- Scanner Section -->
        <div id="scanner-section">
            <form method="POST" id="barcode-form">
                <div class="form-group">
                    <label>Date:</label>
                    <input type="date" name="sdate" value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Item Name:</label>
                    <input type="text" name="item" required>
                </div>
                
                <div class="form-group">
                    <label>Barcode:</label>
                    <input type="text" name="barcode" id="barcode-input" required readonly>
                    <button type="button" onclick="startScanner()">Scan Barcode</button>
                    <button type="button" onclick="stopScanner()">Stop Scanner</button>
                </div>

                <div class="form-group">
                    <label>Customer Name:</label>
                    <input type="text" name="cusname">
                </div>
                
                <div class="form-group">
                    <label>Customer Address:</label>
                    <textarea name="cusadd"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Customer Telephone:</label>
                    <input type="text" name="custele">
                </div>
                
                <div class="form-group">
                    <label>Customer WhatsApp:</label>
                    <input type="text" name="cuswapp">
                </div>
                
                <div class="form-group">
                    <label>Remarks:</label>
                    <textarea name="remark"></textarea>
                </div>
                
                <button type="submit">Save Record</button>
            </form>

            <div class="scanner-container">
                <div id="barcode-scanner" style="display: none;"></div>
            </div>
        </div>

        <!-- Records Section -->
        <div id="records-section" style="display: none;">
            <h3>Recent Records</h3>
            <?php if (count($records) > 0): ?>
                <table class="record-table">
                    <thead>
                        <tr>
                            <th>Ref No</th>
                            <th>Date</th>
                            <th>Item</th>
                            <th>Barcode</th>
                            <th>Customer</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($records as $record): ?>
                        <tr>
                            <td><?php echo $record['ref_no']; ?></td>
                            <td><?php echo $record['sdate']; ?></td>
                            <td><?php echo $record['item']; ?></td>
                            <td><?php echo $record['barcode']; ?></td>
                            <td><?php echo $record['cusname']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No records found.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Show/hide sections
        function showSection(section) {
            document.getElementById('scanner-section').style.display = 
                section === 'scanner' ? 'block' : 'none';
            document.getElementById('records-section').style.display = 
                section === 'records' ? 'block' : 'none';
        }

        // Barcode scanner functions
        let scannerActive = false;

        function startScanner() {
            const scannerElement = document.getElementById('barcode-scanner');
            scannerElement.style.display = 'block';
            
            Quagga.init({
                inputStream: {
                    name: "Live",
                    type: "LiveStream",
                    target: scannerElement,
                    constraints: {
                        width: 480,
                        height: 320,
                        facingMode: "environment"
                    }
                },
                decoder: {
                    readers: ["code_128_reader", "ean_reader", "ean_8_reader", "code_39_reader"]
                }
            }, function(err) {
                if (err) {
                    console.error(err);
                    alert("Error starting scanner: " + err);
                    return;
                }
                Quagga.start();
                scannerActive = true;
            });

            Quagga.onDetected(function(result) {
                const code = result.codeResult.code;
                document.getElementById('barcode-input').value = code;
                stopScanner();
                alert("Barcode scanned: " + code);
            });
        }

        function stopScanner() {
            if (scannerActive) {
                Quagga.stop();
                document.getElementById('barcode-scanner').style.display = 'none';
                scannerActive = false;
            }
        }

        // Show scanner section by default
        showSection('scanner');
    </script>
</body>
</html>