<?php
session_start();
require_once 'config.php';

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Handle form submission
if(isset($_POST['submit'])) {
    $name = $_POST['name'];
    $sdate = $_POST['sdate'];
    $item = $_POST['item'];
    $barcode = $_POST['barcode'];
    $remark = $_POST['remark'];
    $cusname = $_POST['cusname'];
    $cusadd = $_POST['cusadd'];
    $custele = $_POST['custele'];
    $cuswapp = $_POST['cuswapp'];
    $user_name = $_SESSION['user_name'];
    
    $sql = "INSERT INTO x_barcode (sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$sdate, $user_name, $item, $barcode, $remark, $cusname, $cusadd, $custele, $cuswapp]);
    
    $success = "Record added successfully!";
}

// Fetch existing records
$sql = "SELECT ref_no, sdate, user_name, item, barcode, remark, cusname, cusadd, custele, cuswapp FROM x_barcode ORDER BY ref_no DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$records = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard</title>
    <style>
        body { font-family: Arial; margin: 0; background: #f0f0f0; }
        .header { background: #007bff; color: white; padding: 15px; position: fixed; top: 0; width: 100%; z-index: 1000; }
        .nav { display: flex; justify-content: space-around; margin-top: 50px; background: white; padding: 10px; position: fixed; width: 100%; top: 50px; }
        .nav a { padding: 10px; text-decoration: none; color: #007bff; }
        .content { margin-top: 120px; padding: 15px; }
        .form-section, .records-section { background: white; padding: 15px; margin-bottom: 20px; border-radius: 10px; }
        input, textarea { width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 5px; }
        button { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f2f2f2; }
        .success { color: green; margin-bottom: 10px; }
        .scan-btn { background: #28a745; margin: 5px 0; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Barcode Scanner App</h2>
        <div>Welcome, <?php echo $_SESSION['user_name']; ?> | <a href="logout.php" style="color: white;">Logout</a></div>
    </div>
    
    <div class="nav">
        <a href="#form">Add Record</a>
        <a href="#records">View Records</a>
    </div>
    
    <div class="content">
        <div id="form" class="form-section">
            <h3>Add New Barcode Record</h3>
            <?php if(isset($success)) echo "<div class='success'>$success</div>"; ?>
            <form method="POST">
                <input type="text" name="name" placeholder="Name" required>
                <input type="date" name="sdate" required>
                <input type="text" name="item" placeholder="Item" required>
                
                <div style="display: flex;">
                    <input type="text" name="barcode" id="barcode" placeholder="Barcode" required style="flex: 1;">
                    <button type="button" class="scan-btn" onclick="startBarcodeScanner()">Scan</button>
                </div>
                
                <textarea name="remark" placeholder="Remark"></textarea>
                <input type="text" name="cusname" placeholder="Customer Name">
                <input type="text" name="cusadd" placeholder="Customer Address">
                <input type="text" name="custele" placeholder="Customer Telephone">
                <input type="text" name="cuswapp" placeholder="Customer WhatsApp">
                
                <button type="submit" name="submit">Save Record</button>
            </form>
        </div>
        
        <div id="records" class="records-section">
            <h3>Existing Records</h3>
            <div style="overflow-x: auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Ref No</th>
                            <th>Date</th>
                            <th>User</th>
                            <th>Item</th>
                            <th>Barcode</th>
                            <th>Customer</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($records as $record): ?>
                        <tr>
                            <td><?php echo $record['ref_no']; ?></td>
                            <td><?php echo $record['sdate']; ?></td>
                            <td><?php echo $record['user_name']; ?></td>
                            <td><?php echo $record['item']; ?></td>
                            <td><?php echo $record['barcode']; ?></td>
                            <td><?php echo $record['cusname']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
    function startBarcodeScanner() {
        // Check if the browser supports the Barcode Detection API
        if ('BarcodeDetector' in window) {
            const barcodeDetector = new BarcodeDetector();
            
            // Access camera
            navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
            .then(function(stream) {
                const video = document.createElement('video');
                video.srcObject = stream;
                video.play();
                
                // Create a canvas to capture images
                const canvas = document.createElement('canvas');
                const context = canvas.getContext('2d');
                
                // Check for barcodes periodically
                const detectBarcode = () => {
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    context.drawImage(video, 0, 0, canvas.width, canvas.height);
                    
                    barcodeDetector.detect(canvas)
                    .then(barcodes => {
                        if (barcodes.length > 0) {
                            document.getElementById('barcode').value = barcodes[0].rawValue;
                            stream.getTracks().forEach(track => track.stop());
                            alert('Barcode scanned: ' + barcodes[0].rawValue);
                        } else {
                            setTimeout(detectBarcode, 1000);
                        }
                    })
                    .catch(err => {
                        console.error('Barcode detection failed:', err);
                        setTimeout(detectBarcode, 1000);
                    });
                };
                
                detectBarcode();
            })
            .catch(function(err) {
                alert('Error accessing camera: ' + err.message);
                // Fallback to manual input
                document.getElementById('barcode').focus();
            });
        } else {
            // Fallback for browsers that don't support Barcode Detection API
            alert('Barcode scanner not supported in this browser. Please enter barcode manually.');
            document.getElementById('barcode').focus();
        }
    }
    </script>
</body>
</html>