function GetXmlHttpObject()
{
    var xmlHttp = null;
    try
    {
        // Firefox, Opera 8.0+, Safari
        xmlHttp = new XMLHttpRequest();
    } catch (e)
    {
        // Internet Explorer
        try
        {
            xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e)
        {
            xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
    }
    return xmlHttp;
}

function new_inv() {

    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null) {
        alert("Browser does not support HTTP Request");
        return;
    }
    document.getElementById('date').value="";


    var url = "cash_handover_data.php";
    url = url + "?Command=" + "new_inv";

    xmlHttp.onreadystatechange = re_new_inv;
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);
}



function re_new_inv() {
    var XMLAddress1;
    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {

        // XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("uniq");
        // document.getElementById("uniq").value = XMLAddress1[0].childNodes[0].nodeValue;
        //
        // XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("sdate");
        // document.getElementById("sdate").value = XMLAddress1[0].childNodes[0].nodeValue;
        //
        // XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("refno");
        // document.getElementById("refno").value = XMLAddress1[0].childNodes[0].nodeValue;
    }
}
function confirmUnlock() {
    if (confirm("Are you sure you want to unlock this?")) {
        save_inv();
    }
}

function save_inv() {

    var xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null) {
        alert("Browser does not support HTTP Request");
        return;
    }

    document.getElementById('msg_box').innerHTML = "";
    if (document.getElementById('date').value === "") {
        document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>Please Select Date</span></div>";
        return false;
    }

    var url = 'unlock_cash_book_data.php';
    var params = 'Command=save_inv';
    params += '&date=' + encodeURIComponent(document.getElementById('date').value);

    xmlHttp.open("POST", url, true);
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

    // These two headers are not required and often ignored by modern browsers, you can remove them:
    // xmlHttp.setRequestHeader("Content-length", params.length);
    // xmlHttp.setRequestHeader("Connection", "close");

    xmlHttp.onreadystatechange = function () {
        if (xmlHttp.readyState === 4 && xmlHttp.status === 200) {
            if (xmlHttp.responseText.trim() === "Saved") {
                document.getElementById('msg_box').innerHTML = "<div class='alert alert-success' role='alert'><span class='center-block'>Saved</span></div>";
                setTimeout(function () {
                    location.reload(true);
                }, 500);
            } else {
                document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>" + xmlHttp.responseText + "</span></div>";
            }
        }
    };

    xmlHttp.send(params);
}


function re_save_inv()
{
    var XMLAddress1;

    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete")
    {

        if (xmlHttp.responseText == "Saved") {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-success' role='alert'><span class='center-block'>Saved</span></div>";
            setTimeout("location.reload(true);", 500);
        } else {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>" + xmlHttp.responseText + "</span></div>";
        }

    }
}

function pass_inv(code)
{
    //alert(code);
    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null)
    {
        alert("Browser does not support HTTP Request");
        return;
    }
    var url = "cash_handover_data.php";
    url = url + "?Command=" + "pass_inv";
    url = url + "&custno=" + code;

    xmlHttp.onreadystatechange = re_pass_inv;
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);

}


function re_pass_inv()
{
    var XMLAddress1;

    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete")
    {

        XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("id");
        var obj = JSON.parse(XMLAddress1[0].childNodes[0].nodeValue);

        opener.document.getElementById('refno').value = obj.REFNO;
        opener.document.getElementById('sdate').value = obj.SDATE;
        opener.document.getElementById('amount').value = obj.AMOUNT;
        opener.document.getElementById('remark').value = obj.REMARK;

        self.close();
    }
}

function cancel_inv()
{

    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null)
    {
        alert("Browser does not support HTTP Request");
        return;
    }

    var msg = confirm("Do you want to Cancel this ! ");
    if (msg == true) {

        document.getElementById('msg_box').innerHTML = "";
        if (document.getElementById('refno').value == "") {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>Select Entry</span></div>";
            return false;
        }


        var url = 'cash_handover_data.php';
        var params = 'Command=' + 'cancel_inv';
        params = params + '&refno=' + document.getElementById('refno').value;
        params = params + '&uniq=' + document.getElementById('uniq').value;
        xmlHttp.open("POST", url, true);
        xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xmlHttp.setRequestHeader("Content-length", params.length);
        xmlHttp.setRequestHeader("Connection", "close");

        xmlHttp.onreadystatechange = re_cancel;
        xmlHttp.send(params);
    }

}

function re_cancel()
{
    var XMLAddress1;

    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete")
    {

        if (xmlHttp.responseText == "Cancel") {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-success' role='alert'><span class='center-block'>Canceled</span></div>";
            setTimeout("location.reload(true);", 500);
        } else {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>" + xmlHttp.responseText + "</span></div>";
        }

    }
}